import socket
import time
import struct
from pydantic import BaseModel
from typing import List
import google.generativeai as genai
import os
import cv2
import time
import PIL.Image
import numpy as np
import json
import datetime

#genai.configure(api_key="XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") #各自で取得したAPIキーを記載する
model = genai.GenerativeModel('gemini-2.5-flash')

os.environ['QT_QPA_PLATFORM'] = 'xcb'
capture = cv2.VideoCapture(0)
capture.set(cv2.CAP_PROP_BUFFERSIZE, 1)

content_text1 = "現在の日時は"

content_text2 = """
あなたは観葉植物コウモリランの育成管理者です。撮影画像とコウモリランの苔玉に取り付けられたセンサー情報からコンディションを判断し、制御コマンドを出力してください。
センサー情報は次の通りです。
"""
content_text3 ="""
moist_%はコウモリランの苔玉の保水量で％で示しています。moistsen_Vは水分センサーの値で0.7以下の場合に水枯れと判断します。temp_cは温度、humi_%は湿度、press_hPaは気圧です。
制御コマンドは　①condition：コウモリランのコンディション、②water_supply；苔玉への給水指示、③spray：葉水指示、④判断した理由および伝えたいメッセージ100文字以内　をJSON形式で回答してください。
conditionの出力は、NORMAL：普通、FINE：良好、HARD:苦しみ、ANGER：怒り、SLEEPY：休眠、SAD：悲しみ　の6種類から選んでください
water_supplyの出力はコウモリランの苔玉の保水量から判断してください。
sprayはセンサー情報と撮影画像から総合的に判断して出力してください。
water_supplyおよびsprayは、ONかOFFで出力してください。water_supplyとsprayは同時にONはしないでください。
出力例: {"condition": "FINE", "water_supply": "OFF", "spray": "OFF", "message":"各種環境および外見の状態から良好と判断します"}
"""

class Command(BaseModel):
    condition:str
    water_supply:str
    spray:str
    message:str

def get_image():
    ret, frame = capture.read()
    cv2.imshow("Camera View", frame)
    cv2.waitKey(1)
    cv2.imwrite("komoriran_image.jpg", frame )

def koumoriran_ai_commander(
    listen_host='0.0.0.0',
    listen_port=8888,
    forward_host='xxx.xxx.x.xxx', # 制御基板（Raspberrypi Pico2W）のIPアドレスを設定する
    forward_port=8888,
    show_data=True
):
    # 受信用ソケットの作成
    recv_sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    recv_sock.bind((listen_host, listen_port))
    
    # 送信用ソケットの作成
    send_sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    
    print("待機中...\n")
    receive_count = 0
    forward_count = 0
    error_count = 0
    
    try:
        while True:
            # データ受信
            data, addr = recv_sock.recvfrom(4096)
            receive_count += 1
            
            try:
                # バイトデータをデコード
                json_str = data.decode('utf-8')
                # JSONをパース（検証）
                json_data = json.loads(json_str)
                # 受信情報を表示
                print(f"[{receive_count}] 受信元: {addr[0]}:{addr[1]}")
                if show_data:
                    print(f"受信データ:\n{json.dumps(json_data, indent=2, ensure_ascii=False)}")
                dt_now = datetime.datetime.now()
                date = dt_now.strftime('%Y年%m月%d日 %H:%M:%S')
                print(date)
                get_image()
                img = PIL.Image.open('komoriran_image.jpg')
                content_text = content_text1 + date + content_text2 + json_str + content_text3 
                # Geminiへプロンプトを送信
                response = model.generate_content(
                    [content_text, img],
                    generation_config={
                        "response_mime_type": "application/json",
                        "response_schema": Command,
                    },
                    stream=True
                )
                # Geminiからの回答を制御基板へ送信するための処理
                full_response_text = ""
                try:
                   for chunk in response:
                       if chunk.text:
                           full_response_text += chunk.text
                   response_json = json.loads(full_response_text)
                   print("JSON受信データ")
                   print(response_json)
                   # UDP送信のためJSONを文字列へ変換
                   send_json_str = json.dumps(response_json, ensure_ascii=False)

                   # Pydanticモデルで検証
                   command_data = Command(**response_json)

                except json.JSONDecodeError as e:
                   print(f"Gemini回答　JSONパースエラー: {e}")
                   print(f"受信したテキスト: {full_response_text}")

                except Exception as e:
                   print(f"エラーが発生しました: {e}")

                send_sock.sendto(send_json_str.encode('utf-8'), (forward_host, forward_port))
                forward_count += 1
                print(f"→ 転送完了: {forward_host}:{forward_port}")
                print(f"統計 - 受信: {receive_count}, 転送: {forward_count}, エラー: {error_count}")
                print("-" * 60)
                print()
                
            except :
                print("送受信制御エラー")
                print()
                
    except KeyboardInterrupt:
        print("\n\nプログラムを停止します...")
        
    finally:
        recv_sock.close()
        send_sock.close()
        print("ソケットをクローズしました")


if __name__ == "__main__":

    koumoriran_ai_commander()
