#include <ArduinoJson.h>
#include <Wire.h>
#include <Adafruit_Sensor.h>
#include "Adafruit_BME680.h"
#include <Adafruit_NeoPixel.h>

#include <WiFi.h>
#include <WiFiUdp.h>
#include <ArduinoJson.h>

// WiFi設定
const char *ssid = "XXXXXXXX";  // 各自のWiFi SSID　を設定する
const char *password = "XXXXXX"; // SSIDのパスワードを設定する


// UDP設定
WiFiUDP udp;
const unsigned int localPort = 8888;   // 受信ポート番号
const unsigned int targetPort = 8888;  // 送信先ポート
const char *targetIP = "xxx.xxx.x.xxx";  // 各自の送信先（今回はラズベリーパイ）のIPアドレスを設定する
char packetBuffer[512];                  // 受信バッファ



#define SEALEVELPRESSURE_HPA (1005.8)

Adafruit_BME680 bme(&Wire);  // I2C

#include <EEPROM.h>
#include "HX711.h"
#define LOADCELL_DOUT_PIN 21
#define LOADCELL_SCK_PIN 20
HX711 scale;

#define humi_sensor A0
#define sda_pin 4
#define scl_pin 5
#define buzzer 22
#define beat 100
#define neopix 6
#define neopixring 2
#define moss_pump 14
#define spray_pump 15

Adafruit_NeoPixel strip1(2, neopix, NEO_GRB + NEO_KHZ800);
Adafruit_NeoPixel strip2(32, neopixring, NEO_GRB + NEO_KHZ800);

#define LGFX_USE_V1
#include <LovyanGFX.hpp>
#include "bmpdata.h"

#include <SCServo.h>
SMS_STS st;

class LGFX_RPICO_SPI_GC9A01 : public lgfx::LGFX_Device {
  lgfx::Panel_GC9A01 _panel_instance;
  lgfx::Bus_SPI _bus_instance;  // SPIバスのインスタンス
  //lgfx::Light_PWM     _light_instance;
public:
  LGFX_RPICO_SPI_GC9A01(void) {
    {                                     // バス制御の設定を行います。
      auto cfg = _bus_instance.config();  // バス設定用の構造体を取得します。

      // SPIバスの設定
      //      cfg.spi_host = 0 ;//SPI2_HOST;     // 使用するSPIを選択  ESP32-S2,C3 : SPI2_HOST or SPI3_HOST / ESP32 : VSPI_HOST or HSPI_HOST
      cfg.spi_host = 0;  //SPI2_HOST;     // 使用するSPIを選択  ESP32-S2,C3 : SPI2_HOST or SPI3_HOST / ESP32 : VSPI_HOST or HSPI_HOST
      // ※ ESP-IDFバージョンアップに伴い、VSPI_HOST , HSPI_HOSTの記述は非推奨になるため、エラーが出る場合は代わりにSPI2_HOST , SPI3_HOSTを使用してください。
      cfg.spi_mode = 0;           // SPI通信モードを設定 (0 ~ 3)
      cfg.freq_write = 80000000;  // 送信時のSPIクロック (最大80MHz, 80MHzを整数で割った値に丸められます)
                                  //     cfg.freq_read  = 16000000;    // 受信時のSPIクロック
                                  //     cfg.spi_3wire  = true;        // 受信をMOSIピンで行う場合はtrueを設定
                                  //      cfg.use_lock   = true;        // トランザクションロックを使用する場合はtrueを設定
                                  //      cfg.dma_channel = SPI_DMA_CH_AUTO; // 使用するDMAチャンネルを設定 (0=DMA不使用 / 1=1ch / 2=ch / SPI_DMA_CH_AUTO=自動設定)
      // ※ ESP-IDFバージョンアップに伴い、DMAチャンネルはSPI_DMA_CH_AUTO(自動設定)が推奨になりました。1ch,2chの指定は非推奨になります。
      cfg.pin_sclk = 18;                       // SPIのSCLKピン番号を設定
      cfg.pin_mosi = 19;                       // SPIのMOSIピン番号を設定
      cfg.pin_miso = -1;                       // SPIのMISOピン番号を設定 (-1 = disable)
      cfg.pin_dc = 11;                         // SPIのD/Cピン番号を設定  (-1 = disable)
                                               // SDカードと共通のSPIバスを使う場合、MISOは省略せず必ず設定してください。
      _bus_instance.config(cfg);               // 設定値をバスに反映します。
      _panel_instance.setBus(&_bus_instance);  // バスをパネルにセットします。
    }

    {                                       // 表示パネル制御の設定を行います。
      auto cfg = _panel_instance.config();  // 表示パネル設定用の構造体を取得します。
      cfg.pin_cs = 13;                      // CSが接続されているピン番号   (-1 = disable)
      cfg.pin_rst = 12;                     // RSTが接続されているピン番号  (-1 = disable)
      cfg.pin_busy = -1;                    // BUSYが接続されているピン番号 (-1 = disable)
      // ※ 以下の設定値はパネル毎に一般的な初期値が設定されていますので、不明な項目はコメントアウトして試してみてください。
      cfg.memory_width = 240;    // ドライバICがサポートしている最大の幅
      cfg.memory_height = 240;   // ドライバICがサポートしている最大の高さ
      cfg.panel_width = 240;     // 実際に表示可能な幅
      cfg.panel_height = 240;    // 実際に表示可能な高さ
      cfg.offset_x = 0;          // パネルのX方向オフセット量
      cfg.offset_y = 0;          // パネルのY方向オフセット量
      cfg.offset_rotation = 2;   // 回転方向の値のオフセット 0~7 (4~7は上下反転)
      cfg.dummy_read_pixel = 8;  // ピクセル読出し前のダミーリードのビット数
      cfg.dummy_read_bits = 1;   // ピクセル以外のデータ読出し前のダミーリードのビット数
      cfg.readable = true;       // データ読出しが可能な場合 trueに設定
      cfg.invert = true;         // パネルの明暗が反転してしまう場合 trueに設定
      cfg.rgb_order = false;     // パネルの赤と青が入れ替わってしまう場合 trueに設定
      cfg.dlen_16bit = false;    // データ長を16bit単位で送信するパネルの場合 trueに設定
      cfg.bus_shared = true;     // SDカードとバスを共有している場合 trueに設定(drawJpgFile等でバス制御を行います)

      _panel_instance.config(cfg);
    }
    setPanel(&_panel_instance);  // 使用するパネルをセットします。
  }
};

#define BL 10
LGFX_RPICO_SPI_GC9A01 lcd;

static LGFX_Sprite bg(&lcd);  // /Buffer
static LGFX_Sprite wait_state(&bg);
static LGFX_Sprite nomal_state(&bg);
static LGFX_Sprite fine_state(&bg);
static LGFX_Sprite hard_state(&bg);
static LGFX_Sprite anger_state(&bg);
static LGFX_Sprite sad_state(&bg);
static LGFX_Sprite sleepy_state(&bg);
static LGFX_Sprite removed_state(&bg);
static LGFX_Sprite gauge(&lcd);
static LGFX_Sprite gauge_tx(&lcd);

static LGFX_Sprite spray_state(&bg);
static LGFX_Sprite mossply_state(&bg);

#define panel_width 240
#define sw1 7
#define sw2 8
#define sw3 9

//float Weight_adj = 30;  //for black komoriran display
float Weight_adj = -119;  //for white komoriran display
//int cell_adj = 2097;      //for black komoriran display
int cell_adj = 1875;  //for white komoriran display

float Full_Weight;
float Emp_Weight;

int WeightReset = 0;
int moisture_amount = 0;
float Moisture_Voltage = 0.00;
float Weight_val = 0.00;
float Temperature = 0.00;
float Humidity = 0.00;
float Pressure = 0.00;
float Gas = 0.00;
float Altidude = 0.00;

#define WAIT 0
#define NOMAL 1
#define FINE 2
#define HARD 3
#define ANGER 4
#define SAD 5
#define SLEEPY 6
#define REMOVED 7
#define SPRAY 8
#define MOSSPLY 9
#define GAUGE 99

int komori_state = WAIT;
int current_state_buf = WAIT;

struct meter_t {
  int32_t pivot_x;
  int32_t pivot_y;
  float angle = 0;
  float add = 0;

  void drawGauge(uint32_t color) {
    lcd.setPivot(pivot_x, pivot_y);
    gauge.setPaletteColor(1, color);
    if (moisture_amount * 36 / 10 > angle) {
      gauge.pushRotated(angle - 360);
      angle += add;
    }
  }
};
struct meter_t meter;


void colorWipe1(uint32_t color, int wait) {
  for (int i = 0; i < strip1.numPixels(); i++) {
    strip1.setPixelColor(i, color);
    strip1.show();
    delay(wait);
  }
}

void colorWipe2(uint32_t color, int wait) {
  for (int i = 0; i < strip2.numPixels(); i++) {
    strip2.setPixelColor(i, color);
    strip2.show();
    delay(wait);
  }
}

int spraypumpST = 0;

//各シリアルサーボモータのスピードモード毎の動作速度設定
byte ID[6] = { 1, 2, 3, 4, 5, 6 };
u16 Hi_Speed[6] = { 3400, 3400, 3400, 3400, 3400, 3400 };
u16 Mid_Speed[6] = { 1000, 1000, 1000, 1000, 1000, 1000 };
u16 Low_Speed[6] = { 500, 500, 500, 500, 500, 500 };
byte ACC[6] = { 50, 50, 50, 50, 50, 50 };

//ロボットアームの決め打ちポジション設定
s16 Home_Position[6] = { 3092, 880, 3050, 2766, 890, 2066 };
s16 Stand_Position[6] = { 3085, 1626, 1951, 3159, 893, 2066 };
s16 Front_Position[6] = { 2500, 2098, 1341, 2408, 1305, 2066 };
s16 Back_Position[6] = { 2763, 1676, 1349, 2866, 1608, 2066 };
s16 Right_Position[6] = { 2509, 1927, 1349, 2486, 1563, 2066 };
s16 Center_Position[6] = { 2467, 1854, 1321, 2655, 1304, 2081 };
s16 Left_Position[6] = { 2400, 1942, 1348, 2473, 1566, 2066 };

void arm_move_home_position() {
  st.SyncWritePosEx(ID, 6, Home_Position, Low_Speed, ACC);
  delay(3000);
}

void move_splay(int n) {
  digitalWrite(spray_pump, HIGH);
  spraypumpST = 1;
  delay(1000);
  for (int i = 0; i < n; i++) {
    Serial.println("Go to Right");
    st.SyncWritePosEx(ID, 6, Right_Position, Low_Speed, ACC);
    delay(1000);
    Serial.println("Go to Center");
    st.SyncWritePosEx(ID, 6, Center_Position, Low_Speed, ACC);
    delay(1000);
    Serial.println("Go to Left");
    st.SyncWritePosEx(ID, 6, Left_Position, Low_Speed, ACC);
    delay(1000);
    st.SyncWritePosEx(ID, 6, Front_Position, Low_Speed, ACC);
    delay(1000);
    st.SyncWritePosEx(ID, 6, Center_Position, Low_Speed, ACC);
    delay(1000);
  }
  digitalWrite(spray_pump, LOW);
  spraypumpST = 0;
  delay(500);
  st.SyncWritePosEx(ID, 6, Back_Position, Low_Speed, ACC);
  delay(2000);
}

// ロボットアームで葉水を振り撒く関数
void robo_arm_splay() {
  Serial.println("Spray Mode!!");

  colorWipe1(strip1.Color(255, 0, 0), 10);
  tone(buzzer, 700, beat);
  delay(beat);
  tone(buzzer, 500, beat);

  Serial.println("Stand UP!!");
  st.SyncWritePosEx(ID, 6, Stand_Position, Mid_Speed, ACC);
  delay(2000);

  Serial.println("Go to Center");
  st.SyncWritePosEx(ID, 6, Center_Position, Mid_Speed, ACC);
  delay(500);
  colorWipe2(strip2.Color(255, 255, 255), 10);
  tone(buzzer, 500, beat);
  Serial.println("Spray Start!!");

  move_splay(2);
  tone(buzzer, 500, beat);
  Serial.println("Spray end");
  delay(1000);

  Serial.println("Stand UP!!");
  st.SyncWritePosEx(ID, 6, Stand_Position, Low_Speed, ACC);
  delay(1000);

  Serial.println("Go to Home Position");
  arm_move_home_position();
  tone(buzzer, 300, beat);
  delay(1000);

  colorWipe1(strip1.Color(127, 0, 127), 10);
  colorWipe2(strip2.Color(0, 0, 0), 10);
}


// JSONデータを受信する関数
void receiveJsonData() {
  int packetSize = udp.parsePacket();
  String value;

  if (packetSize > 0) {
    Serial.println("--- 受信 ---");
    Serial.print("受信元: ");
    Serial.print(udp.remoteIP());
    Serial.print(":");
    Serial.println(udp.remotePort());
    Serial.print("サイズ: ");
    Serial.print(packetSize);
    Serial.println(" bytes");

    // データ読み込み
    int len = udp.read(packetBuffer, sizeof(packetBuffer) - 1);
    if (len > 0) {
      packetBuffer[len] = '\0';
    }

    Serial.print("受信データ: ");
    Serial.println(packetBuffer);

    // JSONパース
    StaticJsonDocument<512> doc;
    DeserializationError error = deserializeJson(doc, packetBuffer);

    if (error) {
      Serial.print("JSONパースエラー: ");
      Serial.println(error.c_str());
    } else {
      Serial.println("--- パース結果 ---");

      // 受信したJSONの内容を表示
      for (JsonPair kv : doc.as<JsonObject>()) {
        Serial.print(kv.key().c_str());
        Serial.print(": ");
        Serial.println(kv.value().as<String>());
        value = kv.value().as<String>();
        if (kv.key() == "condition") {
          if (value == "NOMAL") komori_state = NOMAL;
          else if (value == "FINE") komori_state = FINE;
          else if (value == "HARD") komori_state = HARD;
          else if (value == "ANGER") komori_state = ANGER;
          else if (value == "SAD") komori_state = SAD;
          else if (value == "SLEEPY") komori_state = SLEEPY;
        } else if (kv.key() == "water_supply") {
          if (value == "ON"){
            current_state_buf = komori_state;
            komori_state = MOSSPLY;
          }
        } else if (kv.key() == "spray") {
          if (value == "ON"){
            current_state_buf = komori_state;
            komori_state = SPRAY;
          }
        }
      }
    }
  }
}


void setup(void) {
  Serial.begin(115200);
  Serial.println("セットアップスタート");

  //シリアルサーボ通信設定
  Serial1.begin(1000000);
  st.pSerial = &Serial1;

  // WiFi接続
  Serial.print("WiFiに接続中: ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nWiFi接続成功!");
  Serial.print("IPアドレス: ");
  Serial.println(WiFi.localIP());
  // UDP開始
  udp.begin(localPort);
  Serial.print("UDP受信待機中 ポート: ");
  Serial.println(localPort);

  tone(buzzer, 400, beat);  //
  delay(beat);
  tone(buzzer, 300, beat);  //
  delay(beat);

  analogReadResolution(12);

  pinMode(sw1, INPUT_PULLUP);
  pinMode(sw2, INPUT_PULLUP);
  pinMode(sw3, INPUT_PULLUP);
  pinMode(moss_pump, OUTPUT);
  pinMode(spray_pump, OUTPUT);
  digitalWrite(moss_pump, LOW);
  digitalWrite(spray_pump, LOW);

  EEPROM.begin(256);
  EEPROM.get(0, Full_Weight);
  EEPROM.get(4, Emp_Weight);
  Serial.print("満水状態の重量は");
  Serial.print(Full_Weight);
  Serial.print("です。枯渇状態の重量は");
  Serial.print(Emp_Weight);
  Serial.println("です。");

  Wire.setSDA(4);
  Wire.setSCL(5);
  Wire.begin();
  if (!bme.begin()) {
    Serial.println("Could not find a valid BME680 sensor, check wiring!");
  }
  bme.setTemperatureOversampling(BME680_OS_8X);
  bme.setHumidityOversampling(BME680_OS_2X);
  bme.setPressureOversampling(BME680_OS_4X);
  bme.setIIRFilterSize(BME680_FILTER_SIZE_3);
  bme.setGasHeater(320, 150);  // 320*C for 150 ms

  scale.begin(LOADCELL_DOUT_PIN, LOADCELL_SCK_PIN);
  //scale.set_scale(2097.f);  // for black komoriran display
  scale.set_scale(1875.f);  // for white komoriran display

  Serial.println("センサ設定終了");

  pinMode(BL, OUTPUT);
  digitalWrite(BL, HIGH);

  lcd.init();
  lcd.clear(TFT_BLACK);
  lcd.setFont(&fonts::Font4);
  lcd.setColorDepth(16);
  bg.setColorDepth(16);
  wait_state.setColorDepth(16);
  nomal_state.setColorDepth(16);
  fine_state.setColorDepth(16);
  hard_state.setColorDepth(16);
  anger_state.setColorDepth(16);
  sad_state.setColorDepth(16);
  sleepy_state.setColorDepth(16);
  removed_state.setColorDepth(16);

  bg.createSprite(240, 240);
  wait_state.setBuffer((uint16_t *)wait, 240, 240, 16);
  nomal_state.setBuffer((uint16_t *)nomal, 240, 240, 16);
  fine_state.setBuffer((uint16_t *)fine, 240, 240, 16);
  hard_state.setBuffer((uint16_t *)hard, 240, 240, 16);
  anger_state.setBuffer((uint16_t *)anger, 240, 240, 16);
  sad_state.setBuffer((uint16_t *)sad, 240, 240, 16);
  sleepy_state.setBuffer((uint16_t *)sleepy, 240, 240, 16);
  removed_state.setBuffer((uint16_t *)removed, 240, 240, 16);
  spray_state.setBuffer((uint16_t *)spray_data, 240, 240, 16);
  mossply_state.setBuffer((uint16_t *)mossply_data, 240, 240, 16);

  gauge_tx.createSprite(125, 125);
  gauge_tx.fillScreen(TFT_BLACK);
  gauge_tx.setFont(&fonts::lgfxJapanMinchoP_20);
  gauge_tx.setTextColor(TFT_RED, TFT_BLACK);

  gauge.setColorDepth(2);
  gauge.createSprite(3, 35);
  gauge.setPivot(1, 120);
  gauge.drawFastVLine(1, 0, gauge.height(), 3);
  gauge.drawFastVLine(0, 2, gauge.height() - 4, 1);
  meter.pivot_x = 120;
  meter.pivot_y = 120;
  meter.add = 0.01;

  Serial.println("LCD設定終了");

  strip1.begin();
  strip1.show();
  strip1.setBrightness(50);

  strip2.begin();
  strip2.show();
  strip2.setBrightness(50);

  colorWipe1(strip1.Color(127, 0, 200), 5);  // Blue
  colorWipe2(strip2.Color(0, 0, 255), 5);    // Blue

  Serial.println("ロボットアームホームポジション");
  arm_move_home_position();

  Serial.println("セットアップ完了");
}

int exist_rest = 0;
int send_trigger_count;
void loop(void) {
  StaticJsonDocument<200> doc;
  //  int count;
  float tmp_val = 0.00;

  Moisture_Voltage = 3.30 * analogRead(humi_sensor) / 4096;
  Weight_val = scale.get_units(10), 2;
  if (WeightReset == 0) Weight_val += Weight_adj;
  if (Weight_val < 20) {
    moisture_amount = 0;
    strip2.setBrightness(255);
    colorWipe1(strip1.Color(255, 255, 255), 5);  //
    colorWipe2(strip1.Color(255, 255, 255), 5);  //
    komori_state = REMOVED;
    if (exist_rest == 0) {
      Serial.println("苔玉が取り外されました。　重量をリセットします");
      delay(500);
      scale.tare();
      exist_rest = 1;
    }
    Serial.print("重量は");
    tmp_val = scale.get_units(10), 2;
    Serial.print(tmp_val);
    Serial.println("g  苔玉の重量設定する場合はSW3を押してください");
    WeightReset = 1;

    if (digitalRead(sw3) == LOW) {  //コウモリラン　重量セットモード
      tone(buzzer, 400, beat);
      while (digitalRead(sw3) == LOW) {  //SW3離すまで待ち
        delay(10);
      }
      while (1) {
        strip2.setBrightness(255);
        colorWipe1(strip1.Color(255, 0, 0), 5);  //
        colorWipe2(strip1.Color(255, 0, 0), 5);  //
        Serial.print("SW1-枯渇重量セット　SW2-満水重量セット　SW3-終了  ");
        Serial.print("現在の重量は");
        tmp_val = scale.get_units(10), 2;
        Serial.print(tmp_val);
        Serial.println("g");

        if (digitalRead(sw1) == LOW) {
          tone(buzzer, 400, beat);
          colorWipe1(strip1.Color(0, 0, 255), 5);  //
          colorWipe2(strip1.Color(0, 0, 255), 5);  //
          while (digitalRead(sw1) == LOW) {        //SW1離すまで待ち
            delay(10);
          }
          lcd.drawString("Set Emp Weight", 20, 130);
          Emp_Weight = scale.get_units(10), 2;
          Serial.print("水分枯渇状態の重量を記憶します");
          EEPROM.put(4, Emp_Weight);
          EEPROM.commit();
          delay(500);
          lcd.drawString("===  Set OK!!  ===", 20, 130);
          Serial.print("枯渇重量がセットされました。");
          Serial.print(Emp_Weight);
          Serial.println("gです");
        } else if (digitalRead(sw2) == LOW) {
          tone(buzzer, 400, beat);
          colorWipe1(strip1.Color(0, 255, 0), 5);  //
          colorWipe2(strip1.Color(0, 255, 0), 5);  //
          while (digitalRead(sw2) == LOW) {        //SW2離すまで待ち
            delay(10);
          }
          lcd.drawString("Set Full Weight", 20, 130);
          Full_Weight = scale.get_units(10), 2;
          Serial.print("満水状態の重量を記憶します");
          EEPROM.put(0, Full_Weight);
          EEPROM.commit();
          delay(500);
          lcd.drawString("===  Set OK!!  ===", 20, 130);
          Serial.print("満水重量がセットされました。　");
          Serial.print(Full_Weight);
          Serial.println("gです");

        } else if (digitalRead(sw3) == LOW) {
          tone(buzzer, 400, beat);
          while (digitalRead(sw3) == LOW) {  //SW3離すまで待ち
            delay(10);
          }
          break;
        } else {
          delay(300);
        }
      }
    }
  } else {
    exist_rest = 0;
    moisture_amount = 100 * (Weight_val - Emp_Weight) / (Full_Weight - Emp_Weight);

    if (!bme.performReading()) {
      Serial.println("Failed to perform reading :(");
    }
    Temperature = bme.temperature;
    Humidity = bme.humidity;
    Pressure = bme.pressure / 100.0;
    Gas = bme.gas_resistance / 1000.0;
    Altidude = bme.readAltitude(SEALEVELPRESSURE_HPA);

    doc["moist_%"] = moisture_amount;
    doc["moistsen_V"] = round(Moisture_Voltage * 100) / 100.0;
    //doc["weight_g"] = round(Weight_val * 100) / 100.0;
    doc["temp_c"] = round(Temperature * 100) / 100.0;
    doc["humi_%"] = round(Humidity * 100) / 100.0;
    doc["press_hPa"] = round(Pressure * 100) / 100.0;
    serializeJson(doc, Serial);
    Serial.println();

    if (komori_state == MOSSPLY) {
      int timeout_count = 0;
      tone(buzzer, 700, beat);
      delay(beat);
      tone(buzzer, 500, beat);
      while (moisture_amount < 90) {
        Weight_val = scale.get_units(10), 2;
        Weight_val += Weight_adj;
        moisture_amount = 100 * (Weight_val - Emp_Weight) / (Full_Weight - Emp_Weight);
        Serial.print("moisuter_amount:");
        Serial.println(moisture_amount);
        digitalWrite(moss_pump, HIGH);
        tone(buzzer, 700, beat);
        delay(1000);
        if (timeout_count <= 30) timeout_count++;
        else {
          Serial.println("PUMP TIME OUT!!");
          break;
        }
      }
      tone(buzzer, 500, beat);
      digitalWrite(moss_pump, LOW);
      komori_state = current_state_buf;
    } else if (komori_state == SPRAY) {
      robo_arm_splay();
      komori_state = current_state_buf;
    } else {
      // JSONを文字列にシリアライズ
      char jsonBuffer[200];
      size_t jsonLength = serializeJson(doc, jsonBuffer);
      Serial.println(jsonLength);

      receiveJsonData();

      if (send_trigger_count > 7200) {  // 1-> 1.5Sec　約3時間間隔で送信する
//      if (send_trigger_count > 40)  { // 1-> 1.5Sec 　デバック用　60秒間隔で送信する
        send_trigger_count = 0;
        current_state_buf = komori_state;  // 現在のステートをバッファに保存する
        komori_state = WAIT;               // データ送信時は返答待ちが判るようにWAITステートにする

        // UDP送信
        udp.beginPacket(targetIP, targetPort);
        udp.write((const uint8_t *)jsonBuffer, jsonLength);
        int result = udp.endPacket();

        Serial.println("--- 送信 ---");
        Serial.print("送信先: ");
        Serial.print(targetIP);
        Serial.print(":");
        Serial.println(targetPort);
        Serial.print("データ: ");
        Serial.println(jsonBuffer);
        Serial.print("送信結果: ");
        Serial.println(result ? "成功" : "失敗");
        Serial.println();

        //receiveJsonData();
      }
      send_trigger_count++;
      delay(100);
    }
  }
}

int count = 0;
int dir = 0;
int led_count = 0;
void loop1() {
  int state_flag = GAUGE;

  while (1) {
    if (count < 1000) {  // 水分量ゲージおよび各種センサーデータ　液晶表示処理
      if (state_flag != GAUGE) {
        lcd.clear(TFT_BLACK);
        meter.angle = 0;
      }
      gauge_tx.setCursor(0, 5);
      gauge_tx.printf("水分%d %%\n", moisture_amount);
      gauge_tx.printf("温度%.1f℃\n", Temperature);
      gauge_tx.printf("湿度%.1f%%\n", Humidity);
      gauge_tx.printf("気圧%.0fhPa\n", Pressure);
      gauge_tx.pushSprite(58, 57);

      while (meter.angle < moisture_amount * 36 / 10) {
        meter.drawGauge(gauge.color888(255 - meter.angle * 0.71, meter.angle * 0.3, meter.angle * 0.71));
      }
      state_flag = GAUGE;
    } else {  // コンディション状態画像の液晶表示、およびLED点灯処理
      switch (komori_state) {
        case WAIT:
          if (state_flag != WAIT) {
            wait_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();
            colorWipe1(strip1.Color(127, 127, 0), 0);  //
            colorWipe2(strip1.Color(127, 127, 0), 0);  //
            state_flag = WAIT;
          }

          break;
        case NOMAL:
          if (state_flag != NOMAL) {
            nomal_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();
            state_flag = NOMAL;
          }
          strip2.setBrightness(led_count);
          colorWipe1(strip1.Color(0, 255, 0), 0); 
          colorWipe2(strip1.Color(0, 255, 0), 0); 
          break;
        case FINE:
          if (state_flag != FINE) {
            fine_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();

            state_flag = FINE;
          }
          strip2.setBrightness(led_count);
          colorWipe1(strip1.Color(0, 127, 127), 0); 
          colorWipe2(strip1.Color(0, 127, 127), 0); 
          break;
        case HARD:
          if (state_flag != HARD) {
            hard_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();
            state_flag = HARD;
          }
          strip2.setBrightness(led_count);
          colorWipe1(strip1.Color(200, 0, 55), 0); 
          colorWipe2(strip1.Color(200, 0, 55), 0); 
          break;
        case ANGER:
          if (state_flag != ANGER) {
            anger_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();

            state_flag = ANGER;
          }
          strip2.setBrightness(led_count);
          colorWipe1(strip1.Color(255, 0, 0), 0);  
          colorWipe2(strip1.Color(127, 0, 64), 0); 
          break;
        case SAD:
          if (state_flag != SAD) {
            sad_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();
            state_flag = SAD;
          }
          strip2.setBrightness(led_count);
          colorWipe1(strip1.Color(127, 64, 0), 0); 
          colorWipe2(strip1.Color(127, 64, 0), 0); 
          break;
        case SLEEPY:
          if (state_flag != SLEEPY) {
            sleepy_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();
            state_flag = SLEEPY;
          }
          strip2.setBrightness(led_count);
          colorWipe1(strip1.Color(0, 0, 64), 0);
          colorWipe2(strip1.Color(0, 0, 64), 0);
          break;
        case REMOVED:
          if (state_flag != REMOVED) {
            removed_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();
            state_flag = REMOVED;
          }
          break;
        case SPRAY:
          if (state_flag != SPRAY) {
            spray_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();
            state_flag = SPRAY;
          }
          count = 1000;
          break;
        case MOSSPLY:
          if (state_flag != MOSSPLY) {
            mossply_state.pushRotateZoom(120, 120, 0, 1, 1);
            bg.pushSprite(0, 0);
            lcd.display();
            state_flag = MOSSPLY;
          }
          count = 1000;
          break;
        default:
          break;
      }
    }
    delay(10);
    if (count > 2000) count = 0;
    else count++;

    // LEDフェード制御
    if (dir == 0) {
      if (led_count >= 255) {
        dir = 1;
      } else led_count += 1;
    } else {
      if (led_count <= 20) {
        dir = 0;
      } else led_count -= 1;
    }
  }
}
