import network
from machine import Pin
import machine
import ssd1306
import time
import sys
import math
import ambient
import gc
import ntptime

RAINDET_PIN = 21      #GP21(27ピン）降雨センサ入力（H/L） 
sda = machine.Pin(0)  #GP0（１ピン）をI2Cのデータラインに設定
scl = machine.Pin(1)  #GP1（２ピン）をI2Cのクロックラインに設定
i2c = machine.I2C(0,sda=sda, scl=scl, freq=400000)  #I2C設定
oled = ssd1306.SSD1306_I2C(128, 64, i2c)  #OLED設定
ssid = const('*********')  #WiFiのSSID
password = const('************')  #WiFiの暗号化キー
wlan = network.WLAN(network.STA_IF)  #WiFi設定
wlan.active(True)  #WiFi有効化
wlan.connect(ssid, password)  #WiFi接続
max_wait = 10  #WiFi接続トライ回数
rain = Pin(RAINDET_PIN, Pin.IN)

def isr(pin):  #割り込みルーチン(転倒枡）
    global prev_time, rain_count
    curr_time = time.ticks_ms()  #ラプスタイム取得
    if curr_time - prev_time > 200:  #チャタリング対策
        rain_count += 1  #雨量カウンタ・アップ
        prev_time = curr_time  #ラプスタイムメモリ更新
        
def isr2(pin):  #割り込みルーチン（流量計）
    global prevx_time2, flow_count, rain_count
    curr_time = time.ticks_ms()
    if curr_time - prevx_time2 > 200:
        flow_count += 1
        prevx_time2 = curr_time
    if flow_count > 4:
        rain_count += 1
        flow_count = 0

trgin = machine.Pin(19, machine.Pin.IN, machine.Pin.PULL_UP)  #GP19の外部割込み（転倒枡）設定
trgin2 = machine.Pin(20, machine.Pin.IN, machine.Pin.PULL_UP)  #GP20の外部割込み（流量計）設定
prev_time = 0  #前回割込みタイミング値初期化（転倒枡）
prevx_time2 = 0 #前回割込みタイミング値初期化（流量計）
rain_count = 0  #雨量カウンタ初期化
flow_count = 0  #流量カウンタ初期化

trgin.irq(trigger = machine.Pin.IRQ_RISING, handler = isr)  #外部割込み設定
trgin2.irq(trigger = machine.Pin.IRQ_RISING, handler = isr2)  #外部割込み設定

while max_wait > 0:  #WiFi接続状態チェック
    if wlan.status() < 0 or wlan.status() >= 3:  #WiFi接続？
        oled.init_display()
        oled.text("WiFi NOT connect.",0,5)  #OLEDにWiFi非接続と表示
        oled.show()
        break
    max_wait -= 1
    oled.init_display()
    oled.text("WiFi connecting.",0,5)  #OLEDにWiFi接続中と表示
    oled.show()
    time.sleep(1)

# NTP設定
ntptime.host = "time.cloudflare.com"  #NTP取得サイト指定
for _ in range(3):  #NTP接続チェック
    try:
        ntptime.settime()  #NTP時刻取得とRTC更新
        print("NTP OK")  #成功、シェルにNTP OKと表示
        break
    
    except Exception as e:  #NTP同期失敗
        print("NTP NG:",e)  #シェルにNTP NGと表示
        time.sleep(2)
else:
    print("getting NTP")  #NTP時刻同期を継続            

# AMBIENT設定
chID = const('*****')    #AmbientのチャネルID
writeKey = const(':***********')   #書き込み用キー（ライトキー）
am = ambient.Ambient(chID, writeKey)  #Ambientの初期化

def raindet_tx():  #時刻、雨量取得、OLED表示、Ambient送信
    global rain_count
    oled.init_display()
    now = time.localtime(time.time() + 9*60*60)  #JST=UTC+９時間
    if now[3]==0 and now[4]==0:  #0時に雨量カウンタをリセットする
        rain_count = 0

    oled.text(str(now[3])+":"+str(now[4])+":"+str(now[5]),0,1)  #OLEDに時刻表示
    oled.text("Rain: ", 0, 16)
    oled.text(str(rain_count), 40, 16)  #OLEDに雨量カウンタ値を表示
    
# AMBIENTに雨量データをアップロード
    r = am.send({'d1': rain_count, 'd2': rain.value()})  #雨量カウンタ値と降雨センサの値(1/0)をAmbientに送信
    oled.text("sent: "+str(r.status_code),0,31) #OLEDにHTTPステータスコード表示(200ならOK）
    oled.show()
# ガベージコレクション
    gc.collect()  #不使用メモリを開放（フリーズ対策）

if __name__ == '__main__':  #メインルーチン
    while True:
        try:
            raindet_tx()  #時刻、雨量取得、OLED表示、Ambient送信
        except KeyboardInterrupt:
            sys.exit()
        time.sleep(60)  #１分ごとに繰り返し


