import time

class E220:
    def __init__(self, uart, m0, m1, aux=None):
        self.uart = uart
        self.m0 = m0
        self.m1 = m1

    def initialize_config(self, addr, ch):
        # 設定モードに切り替え
        self.m0.value(1)
        self.m1.value(1)
        time.sleep(0.1)
        
        # 通信設定
        self.addr = addr & 0xFFFF
        self.ch = ch & 0xFF
        adh = (self.addr >> 8) & 0xFF
        adl = self.addr & 0xFF
        
        # 設定の読み出し
        self.uart.write(bytes([0xC1, 0x00, 0x08]))
        time.sleep(0.1)
        res = self.uart.read()
        print([hex(r) for r in res])
        
        if (res != bytes(
            [0xC1, 0x00, 0x08,
             adh,
             adl,
             0x70,
             0x01,
             self.ch,
             0xC3,
             0x00,
             0x00
            ]
        )):
            self.uart.write(bytes(
                [0xC0, 0x00, 0x08,
                 adh,
                 adl,
                 0x70,
                 0x01,
                 self.ch,
                 0xC3,
                 0x00,
                 0x00,
                ]
            ))
        
            time.sleep(0.1)
            res = self.uart.read()
            print(f"cfg : {[hex(d) for d in res]}")

        # 通信モードに切り替え
        self.m0.value(0)
        self.m1.value(0)

    def read(self):
        if self.uart.any():
            ret = self.uart.read()
            data = ret[:-1]
            rssi = ret[-1] - 256
            return (rssi, data)
        return (None, None)
