#include "main.h"
#include "lora.h"
#include <string.h>


extern UART_HandleTypeDef huart1;

HAL_StatusTypeDef LORA_SetConfig(uint8_t addr, uint8_t ch)
{
	HAL_StatusTypeDef st;

	// 設定用メッセージ
	uint8_t msg[] = {0xC1, 0x00, 0x08};
	HAL_UART_Transmit(&huart1, (uint8_t*)msg, (uint16_t)sizeof(msg), 100);

	uint8_t buf[11] = {0};
	st = HAL_UART_Receive(&huart1, buf, (uint16_t)sizeof(buf), 100);
	if (st == HAL_OK)
	{
		// 意図した設定であるかをチェック
		const uint8_t check[] = {0xC1, 0x00, 0x08, 0x00, addr, 0x70, 0x01, ch, 0x43, 0x00, 0x00};
		if (memcmp(buf, check, sizeof(check)) == 0) return HAL_OK;

		// 一致していない場合は書込み
		uint8_t msg[] = {0xC0, 0x00, 0x08, 0x00, addr, 0x70, 0x01, ch, 0x43, 0x00, 0x00};
		st = HAL_UART_Transmit(&huart1, (uint8_t*)msg, (uint16_t)sizeof(msg), 100);
		if (st == HAL_OK)
		{
			HAL_UART_Receive(&huart1, buf, (uint16_t)sizeof(buf), 100);
			// 書込み後のチェックは割愛
		}
	}

	return st;
}

HAL_StatusTypeDef LORA_SendData(uint8_t addr, uint8_t ch, const uint8_t *data, size_t len)
{
	HAL_StatusTypeDef st;

	uint8_t msg[len + 3];
	msg[0] = 0x00;
	msg[1] = addr;
	msg[2] = ch;
	memcpy(&msg[3], data, len);
	HAL_UART_Transmit(&huart1, (uint8_t*)msg, len + 3, 220);

	return HAL_OK;
}

