#include "main.h"
#include "bq25186.h"

extern I2C_HandleTypeDef hi2c1;

#define BQ25186_I2C_ADDR_7B	(0x6A)
#define BQ25186_I2C_ADDR_8B	(BQ25186_I2C_ADDR_7B << 1)

#define BQ25186_REG_STAT0		(0x00)
#define BQ25186_REG_STAT1		(0x01)
#define BQ25186_REG_FLAG0		(0x02)
#define BQ25186_REG_VBAT_CTRL	(0x03)
#define BQ25186_REG_ICHG_CTRL	(0x04)
#define BQ25186_REG_CHARGECTRL0	(0x05)
#define BQ25186_REG_CHARGECTRL1	(0x06)
#define BQ25186_REG_IC_CTRL		(0x07)
#define BQ25186_REG_TMR_ILIM	(0x08)
#define BQ25186_REG_SHIP_RST	(0x09)
#define BQ25186_REG_SYS_REG		(0x0A)
#define BQ25186_REG_TS_CTRL		(0x0B)
#define BQ25186_REG_MASK_ID		(0x0C)


static HAL_StatusTypeDef _ReadReg(uint8_t reg, uint8_t *val)
{
    return HAL_I2C_Mem_Read(&hi2c1,
                            BQ25186_I2C_ADDR_8B,	// 8-bit address
                            reg,					// register address
                            I2C_MEMADD_SIZE_8BIT,	// 8-bit register
                            val,					// data out
                            1,						// length
                            100);					// timeout[ms]
}

static HAL_StatusTypeDef _WriteReg(uint8_t reg, uint8_t val)
{
    return HAL_I2C_Mem_Write(&hi2c1,
                             BQ25186_I2C_ADDR_8B,	// 8-bit address
                             reg,					// register address
                             I2C_MEMADD_SIZE_8BIT,	// 8-bit register
                             &val,					// data out
                             1,						// length
                             100);					// timeout[ms]
}

HAL_StatusTypeDef BQ25186_SetConfig(void)
{
    // 最大充電電圧：3.9V
    _WriteReg(BQ25186_REG_VBAT_CTRL, 0x28);
    // 最大充電電流（ICHG）：150mA
    _WriteReg(BQ25186_REG_ICHG_CTRL, 0x2A);
    // サーマルしきい値：80C
    _WriteReg(BQ25186_REG_CHARGECTRL0, 0x25);
    // バッテリ放電保護：500mA, UVLO電圧：2.6V
    _WriteReg(BQ25186_REG_CHARGECTRL1, 0x46);
    // WATCHDOG:160s HW_RESET
    _WriteReg(BQ25186_REG_IC_CTRL, 0x85);
    // SYS出力電圧：Tracking-mode, I2C_WATCHDOG:disable
    _WriteReg(BQ25186_REG_SYS_REG, 0x00);
    // VINリミット：200mA
    _WriteReg(BQ25186_REG_TMR_ILIM, 0x4A);

    return HAL_OK;
}


HAL_StatusTypeDef BQ25186_ReadStatus(uint8_t *stat0, uint8_t *stat1, uint8_t *flag0)
{
    HAL_StatusTypeDef st;

    st = _ReadReg(BQ25186_REG_STAT0, stat0);
    if (st != HAL_OK) return HAL_ERROR;
    st = _ReadReg(BQ25186_REG_STAT1, stat1);
    if (st != HAL_OK) return HAL_ERROR;
    st = _ReadReg(BQ25186_REG_FLAG0, flag0);
    if (st != HAL_OK) return HAL_ERROR;

    return HAL_OK;
}
