#include "main.h"
#include "sht4x.h"
#include "util.h"


extern I2C_HandleTypeDef hi2c1;

#define SHT4X_I2C_ADDR_7B	(0x44)
#define SHT4X_I2C_ADDR_8B	(SHT4X_I2C_ADDR_7B << 1)
#define SHT4X_CMD_MEASUREMENT_HIGH			(0xFD)
#define SHT4X_CMD_MEASUREMENT_MEDIAM		(0xF6)
#define SHT4X_CMD_MEASUREMENT_LOW			(0xF0)
#define SHT4X_CMD_HEATER_200MW_1S			(0x39)
#define SHT4X_CMD_HEATER_200MW_100MS		(0x32)
#define SHT4X_CMD_HEATER_110MW_1S			(0x2F)
#define SHT4X_CMD_HEATER_110MW_100MS		(0x24)
#define SHT4X_CMD_HEATER_20MW_1S			(0x1E)
#define SHT4X_CMD_HEATER_20MW_100MS			(0x15)


HAL_StatusTypeDef SHT4X_ReadMeasurement(uint8_t *temp, uint8_t *rh)
{
	HAL_StatusTypeDef st;

	// 計測コマンド送信
	uint8_t cmd = SHT4X_CMD_MEASUREMENT_HIGH;
	st = HAL_I2C_Master_Transmit(&hi2c1, SHT4X_I2C_ADDR_8B, &cmd, 1, 50);
	if (st != HAL_OK) return st;

	HAL_Delay(12);

	// データ受信
	uint8_t rx[6];
	st = HAL_I2C_Master_Receive(&hi2c1, SHT4X_I2C_ADDR_8B, rx, sizeof(rx), 50);
	if (st != HAL_OK) return st;

	// CRCチェック
	if (crc8(&rx[0], 2) != rx[2]) return HAL_ERROR;
	if (crc8(&rx[3], 2) != rx[5]) return HAL_ERROR;

	uint16_t t_raw = ((uint16_t)rx[0] << 8) | rx[1];
	uint16_t h_raw = ((uint16_t)rx[3] << 8) | rx[4];
	float temp_ = -45.0f + 175.0f * ((float)t_raw / 65535.0f);
	float rh_ = -6.0f + 125.0f * ((float)h_raw / 65535.0f);

	if (temp_ < 0.f) temp_ = 0.f;
	if (rh_ < 0.f) rh_ = 0.f;
	if (rh_ > 100.f) rh_ = 100.f;

	*temp = (uint8_t)temp_;
	*rh = (uint8_t)rh_;

	return HAL_OK;
}


HAL_StatusTypeDef SHT4X_Heatup(void)
{
	HAL_StatusTypeDef st;

	// コマンド送信
	uint8_t cmd = SHT4X_CMD_HEATER_20MW_1S;
	st = HAL_I2C_Master_Transmit(&hi2c1, SHT4X_I2C_ADDR_8B, &cmd, 1, 50);
	if (st != HAL_OK) return st;

	return HAL_OK;
}

