/*****  AQM1602Y-FLW-FBW I2C 液晶表示ライブラリ *****/
//  「LiquidCrystal」を元に改造
//  2022-07-19  setContrast,getContrast  LCD_V5R0,LCD_V3R3に
//  2025-09-09  ライブラリ、wire,twiを使わず割り込みを用いない方法で
//				SCL周波数を設定できるように
//  ヘッダーファイル
#ifndef _i2c_lcd_acm1602_tn_h
#define _i2c_lcd_acm1602_tn_h
#include <inttypes.h>
#include <Print.h>
//  電源電圧 3.3V,5V区分
#define LCD_V5R0            0       // 5V   Bonとfollowerの区分
#define LCD_V3R3            1       // 3.3V boosterをon
//コマンド
#define LCD_CLEARDISPLAY    0x01
#define LCD_RETURNHOME      0x02
#define LCD_ENTRYMODESET    0x04
#define LCD_DISPLAYCONTROL  0x08
#define LCD_FUNCTIONSET     0x20
#define LCD_SETDDRAMADDR    0x80
#define LCD_CURSORSHIFT     0x10    // IS=0
#define LCD_SETCGRAMADDR    0x40    // IS=0
#define LCD_OSCFRQ          0x10    // IS=1
#define LCD_SETICONADRS     0x40    // IS=1
#define LCD_POWER           0x50    // IS=1
#define LCD_FOLLOWER        0x60    // IS=1
#define LCD_CONTRAST        0x70    // IS=1

//    76543210
//  0b00000001  0x01    表示クリア(DDRAMアドレス=0)
//  0b00000010  0x02    DDRAMアドレスをゼロに(カーソルをホーム位置に)
//  0b000001is  0x04    エントリーモード    
//          |+--------  s=0:表示シフトなし s=1:表示シフトあり
//          +---------  i=0:デクリメント i=1:インクリメント 
//  0b00001dcb  0x08    表示on/off
//         ||+--------  b=0:文字点滅off b=1:文字点滅on
//         |+---------  c=0:カーソルoff c=1:カーソルon
//         +----------  d=0:表示off d=1:表示on
//  0b0001sr00  0x10    カーソル移動、表示シフト (IS=0)
//        |+----------  r=0:左シフト r=1:右シフト
//        +-----------  s=0:表示シフトしない s=1:表示シフトする
//  0b001dnf0i  0x20    機能設定
//       ||| +--------  IS 機能選択
//       ||+----------  f=0:8行フォント   f=1:11行フォント
//       |+-----------  n=0:1行表示       n=1:2行表示
//       +------------  d=0:4bitモード    d=1:8bitモード
//  0b01aaaaaa  0x40    CGRAMアドレス設定 (IS=0)
//      ++++++--------  a:アドレス 0～3F 8ステップで
//  0b1aaaaaaa  0x80    DDRAMアドレス設定 文字入力位置
//     +++++++--------  a:アドレス 0x00:1行目 0x40:2行目 
//  0b0001B210          内部動作周波数 (IS=1)
//        |+++--------  F2,F1,F0 内部周波数
//        +-----------  BS 1:1/4 0:1/5 bias
//  0b0100aaaa          アイコンアドレス (IS=1)
//        ++++--------  アイコンアドレスカウンタ
//  0b0101ib54          電源,コントラスト (IS=1)
//        ||++--------  コントラスト 上位2bit
//        |+----------  Bon  ブースト 1:3.3V 0:5V ★
//        +-----------  Ion  ICON on/off
//  0b0110f210          follower (IS=1)
//        |+++--------  Rab : follower gain 3bit
//        +-----------  Fon : follower on/off
//  0b01113210          コントラスト(IS=1)
//        ++++--------  C3,2,1,0 コントラスト下位4bit

class i2c_lcd_aqm1602_tn : public Print {
public:
    i2c_lcd_aqm1602_tn(uint8_t adrs);
    void begin(uint8_t cols, uint8_t lines, uint16_t frq, uint8_t v);
    void clear();
    void home();
    void setCursor(uint8_t, uint8_t); 
    void noDisplay();
    void display();
    void noCursor();
    void cursor();
    void noBlink();
    void blink();
    void scrollDisplayLeft();
    void scrollDisplayRight();
    void leftToRight();
    void rightToLeft();
    void autoscroll();
    void noAutoscroll();
    void createChar(uint8_t, uint8_t[]);
    void command(uint8_t);
    virtual size_t write(uint8_t);
    using Print::write;
    void strdisp(const char *s);
    void setContrast(uint8_t n);    // ★
    uint8_t getContrast();          // ★
    uint8_t _numcols;           // 文字数
    uint8_t _numlines;          // 行数
private:
    uint8_t _displayfunction;
    uint8_t _displaycontrol;
    uint8_t _displaymode;
    uint8_t _disppower;         // Power Bon control
    uint8_t _dispfollower;      // Follower control
    uint8_t _i2c_adrs;          // LCDのI2Cアドレス
    uint8_t _row_offsets[4];    // 行先頭のDDRAMアドレス
                                // 2行液晶でも4行分を確保
    uint8_t _contrast;          // コントラスト
};
#endif
// end of "i2c_lcd_aqm1602_tn.h"
