

#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 16, 2);

volatile uint8_t LCD_Life_Count_D = 0;
volatile uint8_t VTG_Velo_Length_L = 0;
volatile uint8_t VTG_Velo_Dot_D = 0;
volatile uint16_t VTG_Velo_FF = 0;
volatile uint16_t VTG_Velo_RR = 0;
volatile uint16_t VTG_Velo_DD = 0;
volatile uint16_t DAC_Velo_DD = 0;

volatile uint8_t VTG_ASCII_B[16] = { 0 };       //GPVTG buffer
volatile boolean VTG_Data_Enable_Flag = false;  //GPVTG data 使用許可フラグ
volatile boolean SW_Flag[3] = { false };        //D2,3,4 SW 用
volatile boolean GNSS_Monitor_Enable_Flag = false;
volatile boolean DAC_OUT_Monitor_Flag = false;
volatile boolean LCD_Enable_Flag = false;

//--------------------------------------------------------------------------
void setup() {
  //--- Enable_Flag set ---
  //GNSS_Monitor_Enable_Flag = true;
  //DAC_OUT_Monitor_Flag = true;
  LCD_Enable_Flag = true;
  //--- UART set UP ---
  Serial.begin(1000000);  //USB for Debug
  Serial1.begin(9600);    //TRX Port for GPS
  //--- Digital port set ----
  pinMode(2, INPUT_PULLUP);  //
  pinMode(3, INPUT_PULLUP);  //
  pinMode(4, INPUT_PULLUP);  //
  //--- ADC Resolution set UP ---
  analogReadResolution(12);  //ADC分解能設定
  //analogReadResolution(14);  //ADC分解能設定
  //--- DAC set UP ---
  analogWriteResolution(12);  //DAC分解能設定
  analogWrite(DAC, 4000);
  digitalWrite(13, HIGH);
  //--- I2C LCD set UP ---

  if (LCD_Enable_Flag == true) {
    lcd.begin(16, 2);  //LCD 16x2
    lcd.init();        //LCD initialize
    lcd.backlight();   //Back Light ON
    //--- LCD IND. ---
    LCD_Opening();
  }

  delay(7000);
  digitalWrite(13, LOW);
}
