void VTG_Data_Processing_loop() {
  uint8_t byte_A = 0;
  uint8_t byte_B = 0;
  uint8_t byte_C = 0;
  uint8_t byte_D = 0;
  uint8_t byte_I = 0;
  uint16_t AA = 0;
  uint16_t BB = 0;
  uint16_t CC = 0;
  uint16_t DD = 0;
  uint32_t AAAA = 0;
  uint32_t BBBB = 0;
  //----------------------------------------------------------------
  if (VTG_Data_Enable_Flag == true) {
    VTG_Data_Enable_Flag = false;
    //----------------------------------------------
    LCD_Life_Count_D++;
    LCD_Life_Count_D = LCD_Life_Count_D & B00000111;
    //-------------------------------------------------------------
    for (byte_I = 0; byte_I < 16; byte_I++) {  //"." 小数点の位置検出
      if (VTG_ASCII_B[byte_I] == 0x2e) {       //"."の検出
        VTG_Velo_Dot_D = byte_I;
      }
      if (VTG_ASCII_B[byte_I] == 0x0d) {  //[CR]の検出
        VTG_Velo_Length_L = byte_I;
      }
    }
    //----------------------------------------------------
    //小数点より上位の計算
    // VTG_Velo_Dot_D <=== 小数点より上位の桁数を示している
    switch (VTG_Velo_Dot_D) {
      //______________________________________
      case 1:
        byte_A = VTG_ASCII_B[0] & B00001111;
        AA = byte_A;
        //VTG_Velo_FF = AA;
        break;
      //______________________________________
      case 2:
        byte_A = VTG_ASCII_B[1] & B00001111;
        byte_B = VTG_ASCII_B[0] & B00001111;
        AA = byte_A;
        BB = byte_B * 10;
        AA = AA + BB;
        //VTG_Velo_FF = AA;
        break;
      //______________________________________
      case 3:
        byte_A = VTG_ASCII_B[2] & B00001111;
        byte_B = VTG_ASCII_B[1] & B00001111;
        byte_C = VTG_ASCII_B[0] & B00001111;
        AA = byte_A;
        BB = byte_B * 10;
        CC = byte_C * 100;
        AA = AA + BB;
        AA = AA + CC;
        //VTG_Velo_FF = AA;
        break;
      //______________________________________
      case 4:
        byte_A = VTG_ASCII_B[3] & B00001111;
        byte_B = VTG_ASCII_B[2] & B00001111;
        byte_C = VTG_ASCII_B[1] & B00001111;
        byte_D = VTG_ASCII_B[0] & B00001111;
        AA = byte_A;
        BB = byte_B * 10;
        CC = byte_C * 100;
        DD = byte_D * 1000;
        AA = AA + BB;
        AA = AA + CC;
        AA = AA + DD;
        //VTG_Velo_FF = AA;
        break;
      //______________________________________
      default:
        //VTG_Velo_FF = 0;
        AA = 0;
    }
    VTG_Velo_FF = constrain(AA, 0, 1999);
    //小数点より下位の計算
    switch (VTG_Velo_Length_L - VTG_Velo_Dot_D) {
      //_________________________________________________________
      case 2:
        byte_A = VTG_ASCII_B[VTG_Velo_Dot_D + 1] & B00001111;
        AA = byte_A * 100;
        //VTG_Velo_RR = AA;
        break;
      //_________________________________________________________
      case 3:
        byte_A = VTG_ASCII_B[VTG_Velo_Dot_D + 1] & B00001111;
        byte_B = VTG_ASCII_B[VTG_Velo_Dot_D + 2] & B00001111;
        AA = byte_A * 100;
        BB = byte_B * 10;
        AA = AA + BB;
        //VTG_Velo_RR = AA;
        break;
      //_________________________________________________________
      case 4:
        byte_A = VTG_ASCII_B[VTG_Velo_Dot_D + 1] & B00001111;
        byte_B = VTG_ASCII_B[VTG_Velo_Dot_D + 2] & B00001111;
        byte_C = VTG_ASCII_B[VTG_Velo_Dot_D + 3] & B00001111;
        AA = byte_A * 100;
        BB = byte_B * 10;
        CC = byte_C;
        AA = AA + BB;
        AA = AA + CC;
        //VTG_Velo_RR = AA;
        break;
      //_________________________________________________________
      default:
        //VTG_Velo_RR = 0;
        AA = 0;
    }
    VTG_Velo_RR = constrain(AA, 0, 999);  //999 = 0.999
    //---------------------------------------------
    //DAC 分解能は12bit
    //GPVTG としては1800Km/hまで計測できるようであるが、
    //100km/hも出ないので、
    //切りの良いところで80Km/h==>DAC4000 に割り振る。
    AAAA = VTG_Velo_FF;     //Max 1800
    AAAA = AAAA * 100;      //1800 --->180000
    BB = VTG_Velo_RR / 10;  //999--->99
    BBBB = BB;
    AAAA = AAAA + BBBB;             //180000
    if (AAAA >= 8000) AAAA = 8000;  //Max 80.00Km/h　とする
    VTG_Velo_DD = AAAA;
    DAC_Velo_DD = VTG_Velo_DD / 2;  //4000 = 8000(x0.01Km/h)とする。
    //---------------------------
    if (SW_Flag[2] == true) {
      DAC_Velo_DD = 4095;
    }
    //----------------------------------------
    if (DAC_OUT_Monitor_Flag == true) {
      Serial.print(DAC_Velo_DD);
      Serial.println();
    }  //---------------------------
  }    //if end
}  //void loop end
