void LCD_loop() {

  uint16_t AA = 0;
  uint16_t BB = 0;
  uint16_t CC = 0;
  uint16_t DD = 0;
  uint16_t LL = 0;
  static uint8_t LCD_M = 0;
  static uint8_t LCD_I = 0;
  static uint16_t LCD_ASCII_DD[20][2] = { 0 };

  static uint16_t SS = 0;
  static uint16_t TT = 0;
  static uint16_t UU = 0;
  if (LCD_Enable_Flag == true) {
    TT = millis();
    SS = TT - UU;
    if (SS >= 2) {
      UU = TT;

      switch (LCD_M) {
        //LCD表示イメージ
        //0123456789ABCDEF
        //##.### FFFF/RRRR
        //00.00K > 0000  L
        //-----------------------------------------
        case 0:  //受信したGPVTG Velo.表示
          for (LCD_I = 0; LCD_I < 6; LCD_I++) {
            if (VTG_ASCII_B[LCD_I] > 0x1f) {
              LCD_ASCII_DD[LCD_I][0] = VTG_ASCII_B[LCD_I];
            } else {
              //LCD_ASCII_DD[LCD_I][0] = 0x2d;  //"-"
              LCD_ASCII_DD[LCD_I][0] = 0x23;  //"#"
            }
          }
          LCD_ASCII_DD[6][0] = 0x20;  //" "(SPACE)
          LCD_M++;
          break;
        //-----------------------------------------
        case 1:  //Velo.データ　小数点より前　表示
          LL = VTG_Velo_FF;
          AA = LL % 10;
          LL = LL / 10;
          BB = LL % 10;
          LL = LL / 10;
          CC = LL % 10;
          DD = LL / 10;
          LCD_ASCII_DD[7][0] = DD + 0x30;   //ASCII
          LCD_ASCII_DD[8][0] = CC + 0x30;   //ASCII
          LCD_ASCII_DD[9][0] = BB + 0x30;   //ASCII
          LCD_ASCII_DD[10][0] = AA + 0x30;  //ASCII
          LCD_ASCII_DD[11][0] = 0x2f;       //"/"
          LCD_M++;
          break;
        //-----------------------------------------
        case 2:  //Velo.データ　小数点より後　表示
          LL = VTG_Velo_RR;
          //AA = LL % 10;
          //LL = LL / 10;
          BB = LL % 10;
          LL = LL / 10;
          CC = LL % 10;
          DD = LL / 10;
          LCD_ASCII_DD[12][0] = DD + 0x30;  //ASCII
          LCD_ASCII_DD[13][0] = CC + 0x30;  //ASCII
          LCD_ASCII_DD[14][0] = BB + 0x30;  //ASCII
          //LCD_ASCII_DD[15][0] = AA + 0x30;  //ASCII
          LCD_ASCII_DD[15][0] = 0x20;  //" "(SPACE)
          LCD_M++;
          break;
        //-----------------------------------------
        case 3:              //GPVTG Velocity data calculation
          LL = VTG_Velo_DD;  //next data set
          AA = LL % 10;
          LL = LL / 10;
          BB = LL % 10;
          LL = LL / 10;
          CC = LL % 10;
          DD = LL / 10;
          LCD_ASCII_DD[0][1] = DD + 0x30;  //ASCII
          LCD_ASCII_DD[1][1] = CC + 0x30;  //ASCII
          LCD_ASCII_DD[2][1] = 0x2e;       //ASCII "."
          LCD_ASCII_DD[3][1] = BB + 0x30;  //ASCII
          LCD_ASCII_DD[4][1] = AA + 0x30;  //ASCII
          LCD_ASCII_DD[5][1] = 0x4b;       //ASCII "K"
          LCD_ASCII_DD[6][1] = 0x20;       //ASCII " "(SPACE)
          LCD_ASCII_DD[7][1] = 0x3e;       //ASCII ">"
          LCD_ASCII_DD[8][1] = 0x20;       //ASCII " "(SPACE)
          LCD_I = 0;                       //count clear
          LCD_M++;                         // next case
          break;
        //-----------------------------------------
        case 4:
          lcd.setCursor(0, 1);
          LL = DAC_Velo_DD;
          AA = LL % 10;
          LL = LL / 10;
          BB = LL % 10;
          LL = LL / 10;
          CC = LL % 10;
          DD = LL / 10;
          LCD_ASCII_DD[9][1] = DD + 0x30;   //ASCII
          LCD_ASCII_DD[10][1] = CC + 0x30;  //ASCII
          LCD_ASCII_DD[11][1] = BB + 0x30;  //ASCII
          LCD_ASCII_DD[12][1] = AA + 0x30;  //ASCII
          LCD_ASCII_DD[13][1] = 0x20;       //ASCII " "(SPACE)
          LCD_ASCII_DD[14][1] = 0x20;       //ASCII " "(SPACE)
          LCD_M++;                          // next case        break;
        //-----------------------------------------
        case 5:
          AA = LCD_Life_Count_D;
          LCD_ASCII_DD[15][1] = AA + 0x30;  //ASCII
          LCD_I = 0;                        //count clear
          LCD_M++;
          break;
        //-----------------------------------------
        case 6:
          LCD_M++;  // next case
          break;
          //-----------------------------------------
        case 7:  //LCD １行目に設定
          lcd.setCursor(0, 0);
          LCD_I = 0;  //count clear
          LCD_M++;
          break;
        //-----------------------------------------
        case 8:  //LCD １行目表示データ書き込み
          if (LCD_I < 16) {
            lcd.write(LCD_ASCII_DD[LCD_I][0]);
            LCD_I++;
          } else {
            LCD_I = 0;  //count clear
            LCD_M++;    // next case
          }
          break;
        //-----------------------------------------
        case 9:  //LCD ２行目に設定
          lcd.setCursor(0, 1);
          LCD_I = 0;  //count clear
          LCD_M++;
          break;
        //-----------------------------------------
        case 10:  //LCD ２行目表示データ書き込み
          if (LCD_I < 16) {
            lcd.write(LCD_ASCII_DD[LCD_I][1]);
            LCD_I++;
          } else {
            LCD_I = 0;  //count clear
            LCD_M++;    // next case
          }
          break;
        //-----------------------------------------
        case 11:
        case 12:
        case 13:
        case 14:
          LCD_M++;
          break;
          //-----------------------------------------
        default:
          LCD_M = 0;
      }  //sitch loop end
    }    //if loop end
  }      //LCD_Enable_Flag
}  //void loop end
