//  1Hz位相差検出
//      D2   P105  GPT1A  キャプチャ入力A 外部から1Hzを入力 ↓を検出
//                        キャプチャと同時にGTCNTクリア  
//      D3   P104  GPT1B  キャプチャ入力B 比較入力 ↓を検出
/*****  ＳＥＴＵＰ   *****/
void setup() {
//  モジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD5  = 0;  // 32bit PWMモジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD14 = 0;  // POEGモジュールストップ解除
//  D2:P105  GPT1A  キャプチャ入力A
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PCR  = 1;        // P105入力pullup
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PSEL = 0b00010;  // GTETRGA入力に
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PMR  = 1;        // 周辺機能有効
    R_GPT1->GTICASR_b.ASGTRGAF          = 1;        // A↓でキャプチャ
    R_GPT1->GTCSR_b.CSGTRGAF            = 1;        // A↓でクリア
//  D3:P104  GPT1B  キャプチャ入力B
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PCR  = 1;        // P105入力pullup
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PSEL = 0b00010;  // GTETRGB入力に
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PMR  = 1;        // 周辺機能有効
    R_GPT1->GTICBSR_b.BSGTRGBF          = 1;        // B↓でキャプチャ
    R_GPT1->GTCR_b.CST                  = 1;        // GPT1カウント開始
}
/*****  ＬＯＯＰ   *****/
void loop() {
int32_t cap_a, cap_b;   // キャプチャA,B値
                        // Aにジャスト1Hzを入れるとcap[0]は48000000となる
int32_t dif_ab;         // 差分(A-B)データ プラスの値
int32_t mem_ab;         // 前回の差分保存データ
int32_t dif_dev;        // 差分からの偏差
int32_t mem_dev;        // 偏差保存データ
int32_t mem_capa;       // cap A保存データ
byte    f_mab   = 0;    // A-B差分保存済みフラグ
byte    f_print = 0;    // データ出力指令フラグ
char str_bff[80];       // 文字出力バッファ sprintfで使用
    Serial.begin(9600);         // 9600BPSで
    while (!Serial);            // USB接続チェック
    Serial.println("Phase check"); // タイトル
    while(1){
      if(R_GPT1->GTST_b.TCFA){      // キャプチャA発生
        R_GPT1->GTST_b.TCFA = 0;    // Aフラグクリア
        if(R_GPT1->GTST_b.TCFB){    // キャプチャBあり?
          R_GPT1->GTST_b.TCFB = 0;  // Bフラグクリア
          cap_a = R_GPT1->GTCCR[0]; // CAP Aデータ保存
          cap_b = R_GPT1->GTCCR[1]; // CAP Bデータ保存
          dif_ab = cap_a - cap_b;     // A-B 差分
          if(f_mab == 0){             // 初めての差分
            f_mab  = 1;
            mem_ab   = dif_ab;        // 差分を保存
            mem_capa = cap_a;         // Aキャプチャ値を保存
          }
          else{                       // 差分2回目以降
            dif_dev = dif_ab - mem_ab;        // 偏差:差分の差
            if(abs(dif_dev) >= (cap_a / 2)){  // 前回との差が48Mの半分越え
              if(dif_dev >= 0){               // 差がプラス
                dif_dev = dif_dev - cap_a;    // 偏差を修正
              }
              else{                           // 差がマイナス
                dif_dev = dif_dev - mem_dev + mem_capa; // 偏差を修正
              }
            }
            sprintf(str_bff, "%11u %11u %11d %11d",
                    cap_a, cap_b,   // A,Bキャプチャ値
                    dif_ab,         // A-B差分
                    dif_dev);       // 偏差
            Serial.println(str_bff);
            mem_ab   = dif_ab;        // 差分を保存
            mem_dev  = dif_dev;       // 偏差を保存
            mem_capa = cap_a;         // Aキャプチャ値を保存
          }
        }
      }
    }
}    
