//  Arduino UNO R4 minima 周波数カウンタ
//      D2   P105  GTIOC1A  クロック入力
//      D3   P104  GTIOC1B  キャプチャ入力
//      D4   P103  GTIOC2A  1Hz方形波出力
/*****  SETUP  *****/
void setup()
{
//  プロテクト解除
    R_MSTP->MSTPCRD_b.MSTPD5  = 0;   // 32bit PWMモジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD6  = 0;   // 16bit PWMモジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD14 = 0;   // POEGモジュールストップ解除
//  GPT2(16bit) D4 P103 GTIOC2A 1Hz方形波出力
    R_PFS->PORT[1].PIN[3].PmnPFS_b.PDR  = 1;        // ポート出力
    R_PFS->PORT[1].PIN[3].PmnPFS_b.PSEL = 0b00011;  // GTIOC2A出力に
    R_PFS->PORT[1].PIN[3].PmnPFS_b.PMR  = 1;        // 周辺機能有効
    R_GPT2->GTCR_b.TPCS   = 0b1010;     // PCLKD/1024 46875Hz
    R_GPT2->GTPR          = 46875 - 1;  // 1Hz
    R_GPT2->GTCCR[0]      = 46875 / 2;  // GTIOC2AがHになるカウント
    R_GPT2->GTIOR_b.GTIOA = 0b00110;    // GTIOC2A 周期の終わりでL, A一致でH
    R_GPT2->GTIOR_b.OAE   = 1;          // A出力許可
    R_GPT2->GTCR_b.CST    = 1;          // カウント開始
//  GPT1(32bit) D3 P104 GTIOC1B インプットキャプチャAに
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PCR  = 1;        // P104入力pullup
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PSEL = 0b00010;  // GTETRGB入力に
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PMR  = 1;        // 周辺機能有効
    R_GPT1->GTICASR_b.ASGTRGBF          = 1;        // B↓でキャプチャA
    R_GPT1->GTCSR_b.CSGTRGBF            = 1;        // B↓でクリア
//  GPT1(32bit) D2 P105 GTIOC1A クロック入力 upカウント
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PCR  = 1;        // P105入力pullup
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PSEL = 0b00010;  // GTETRGA入力に
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PMR  = 1;        // 周辺機能有効
    R_GPT1->GTUPSR_b.USGTRGAF           = 1;        // A↓でカウントアップ
    R_GPT1->GTCR_b.CST                  = 1;        // カウント開始
}
/*****  LOOP  *****/
void loop()
{
char str_bff[40];       // 文字出力バッファ sprintfで使用
    Serial.begin(9600);         // シリアル 9600BPSで
    while (!Serial);            // USB接続okチェック
    Serial.println("Frq counter");  // タイトル
//  loop
    while(1){
      if(R_GPT1->GTST_b.TCFA){      // キャプチャA発生?
        R_GPT1->GTST_b.TCFA = 0;    // キャプチャAクリア
        sprintf(str_bff, "%8ld.%03ldkHz", // 周波数表示
                R_GPT1->GTCCR[0] / 1000,  // キャプチャAデータ
                R_GPT1->GTCCR[0] % 1000);
        Serial.println(str_bff);
      }
    }
}
