//  2相パルス Up/Downカウンタ
//      D2   P105  GPT1A  クロック入力↓↑エッジカウント
//      D3   P104  GPT1B  クロック入力↓↑エッジカウント
//      A5   P100  IRQ2   クリア入力
/*****  SETUP  *****/
void setup()
{
//  モジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD5  = 0;   // 32bit PWMモジュールストップ解除
    R_MSTP->MSTPCRC_b.MSTPC14 = 0;   // ELCモジュールストップ解除
//  A5 P100 IRQ2入力をELC_GPTAに
    R_PFS->PORT[1].PIN[0].PmnPFS_b.PCR  = 1;        // P100入力pullup
    R_PFS->PORT[1].PIN[0].PmnPFS_b.ISEL = 1;        // IRQ2入力許可
    R_ELC->ELSR[0].HA                   = 0x03;     // IRQ2でELC_GPTA発生
    R_ELC->ELCR_b.ELCON                 = 1;        // ELCオン
//  D2   P105  GPT1A  クロック入力 up/downカウント
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PCR  = 1;        // P105入力pullup
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PSEL = 0b00011;  // GTIOC1A入力に
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PMR  = 1;        // 周辺機能有効
//  D3   P104  GPT1B  クロック入力 up/downカウント
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PCR  = 1;        // P104入力pullup
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PSEL = 0b00011;  // GTIOC1B入力に
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PMR  = 1;        // 周辺機能有効
//  カウントアップ条件
    R_GPT1->GTUPSR_b.USCARBL  = 1;        // A↑,B=Lでカウントアップ
    R_GPT1->GTUPSR_b.USCAFBH  = 1;        // A↓,B=Hでカウントアップ
    R_GPT1->GTUPSR_b.USCBRAH  = 1;        // B↑,A=Hでカウントアップ
    R_GPT1->GTUPSR_b.USCBFAL  = 1;        // B↓,A=Lでカウントアップ
//  カウントダウン条件
    R_GPT1->GTDNSR_b.DSCARBH   = 1;        // A↑,B=Hでカウントダウン
    R_GPT1->GTDNSR_b.DSCAFBL   = 1;        // A↓,B=Lでカウントダウン
    R_GPT1->GTDNSR_b.DSCBRAL   = 1;        // B↑,A=Lでカウントダウン
    R_GPT1->GTDNSR_b.DSCBFAH   = 1;        // B↓,A=Hでカウントダウン
//  カウント開始
    R_GPT1->GTPR               = 360 - 1;  // 最大値を設定
    R_GPT1->GTCSR_b.CSELCA     = 1;        // ELC_GPTAでカウンタをクリア
    R_GPT1->GTCR_b.CST         = 1;        // カウント開始
}
/*****  LOOP  *****/
void loop()
{
uint32_t ms;          // 1ms経過時間
int32_t  cnt;         // カウント値
byte     f_disp = 1;  // 表示フラグ
char     str_bff[40]; // 文字出力バッファ sprintfで使用
//  シリアル
    Serial.begin(9600);         // 9600BPSで
    while (!Serial);            // USB接続チェック
    Serial.println("Up/Down count");  // タイトル
//  loop
    ms  = millis();       // 現在値を
    cnt = R_GPT1->GTCNT;  // リード
    while(1){
      if(cnt != R_GPT1->GTCNT){     // カウント値変化
        if(millis() >= (ms+500)){   // 0.5秒以上経過
          f_disp = 1;               // 表示フラグをon
        }
      }
      if(f_disp){       // 表示指令
        f_disp = 0;
        cnt = R_GPT1->GTCNT;          // カウント値
        ms  = millis();               // 経過時間
        sprintf(str_bff, "%d", cnt);  // カウント値
        Serial.println(str_bff);
      }
    }
}
