//  パルス周期とデューティ比の測定
//      D2  P105  GPT1A  キャプチャ入力A 計測パルス入力
//          ↑エッジの間隔で周期を計測
//             キャプチャと同時にGTCNTクリア  
//          ↓でをH区間のパルス幅を計測
#define CLK_FRQ   48000000u   // 48MHz クロック周波数
/*****  ＳＥＴＵＰ   *****/
void setup() {
//  モジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD5  = 0;  // 32bit PWMモジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD14 = 0;  // POEGモジュールストップ解除
//  D2 P105  GPT1  キャプチャ入力A,キャプチャ入力B
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PCR  = 1;        // P105入力pullup
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PSEL = 0b00010;  // GTETRGA入力に
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PMR  = 1;        // 周辺機能有効
    R_GPT1->GTICASR_b.ASGTRGAR          = 1;        // A↑でキャプチャ
    R_GPT1->GTCSR_b.CSGTRGAR            = 1;        // A↑でクリア
    R_GPT1->GTICBSR_b.BSGTRGAF          = 1;        // B↓でキャプチャ
//  オーバーフロー2秒をセット
    R_GPT1->GTPR                        = 2 * 48000000u;  // 2*48MHz
    R_GPT1->GTCR_b.CST                  = 1;        // GPT1カウント開始
}
/*****  ＬＯＯＰ   *****/
void loop() {
uint32_t a, b;        // cap A, cap Bデータ
uint32_t ms;          // 1msカウントデータ
byte f_capa = 0;      // cap A(↑) 2回をチェック
char str_bff[80];     // 文字出力バッファ sprintfで使用
    Serial.begin(9600);         	// 9600BPSで
    while (!Serial);            	// USB接続チェック
    Serial.println("Duty check");	// タイトル
    ms = millis();				    // 現時間
    while(1){
      if(R_GPT1->GTST_b.TCFPO){     // 2秒経過(オーバーフローをチェック)
        R_GPT1->GTST_b.TCFPO = 0;   // オーバーフロークリア
        Serial.println("#No pulse.");   // パルス無し
        f_capa = 0;                     // 2回のcap Aを待つ
      }
      if(R_GPT1->GTST_b.TCFA){    // キャプチャAあり?
        R_GPT1->GTST_b.TCFA = 0;  // Aフラグクリア
        if(f_capa == 0){          // cap A 2回を待つ
          f_capa = 1;
        }
        else{                   // cap Aパルス幅有効
          if(millis() >= (ms + 500)){ // 0.5秒おきに出力
            ms = millis();
            a  = R_GPT1->GTCCR[0],    // cap Aデータ 周期
            b  = R_GPT1->GTCCR[1],    // cap Bデータ H幅
            sprintf(str_bff, "%10u %10u %7.3f%c %11.4fkHz",
                a , b,                            // 周期, H幅
                (float)b / (float)a * 100.0,      // duty
                '%',
                (float)CLK_FRQ / (float)a / 1000.0); // kHz
            Serial.println(str_bff);
          }
        }
      }
    }
}
