//  Arduino UNO R4 minima 周波数カウンタ
//  　 POEGモジュールをスキップして高速化
//      D2   P105  GTIOC1A  クロック入力
//      D3   P104  GTIOC1B  キャプチャ入力
//      D4   P103  GTIOC2A  1Hz方形波出力
//      D8   P304  GTIOC7A  1MHz方形波出力
//      水晶発振+PLLできるように
/*****  メインクロックをPLLに切り替え   *****/
//  m:逓倍値(8～16)   d:分周値(2,4)
//      mもdも範囲チェックしていない
void PLLon(int m, int d)
{
    R_SYSTEM->PRCR = 0xA501;        // クロック関連レジスタのプロテクト解除
//  メインクロック水晶発振
    R_SYSTEM->MOSCWTCR = 0b1001;    // 発振安定32.768ms待ち (初期値2.08ms)
    R_SYSTEM->MOSCCR_b.MOSTP = 0;   // XTAL発振開始
    while(!R_SYSTEM->OSCSF_b.MOSCSF);   // 発振安定待ち MOSCSFが1で安定
//  PLL切り替え
    R_SYSTEM->PLLCCR2_b.PLLMUL = m - 1; // m逓倍 (8～31)
    R_SYSTEM->PLLCCR2_b.PLODIV = d / 2; // d分周 (2,4)
    R_SYSTEM->PLLCR_b.PLLSTP   = 0;     // PLL開始
    while(!R_SYSTEM->OSCSF_b.PLLSF);;   // PLL安定待ち PLLSFが1で安定
    R_SYSTEM->SCKSCR_b.CKSEL = 0b101;   // クロックソースをPLLに
    R_SYSTEM->PRCR = 0xA500;            // プロテクト戻す
}
/*****  SETUP  *****/
void setup()
{
//  水晶発振on 48MHz発生 (逓倍数,分周比を指定)
    PLLon(8, 2);          // PLLに切り替え (12MHz*8/2)
//  PLLon(6, 2);          // ★            (16MHz*6/2)
//  PLLon(8, 4);          // ★            (16MHz*8/4)
//  プロテクト解除
    R_MSTP->MSTPCRD_b.MSTPD5  = 0;   // 32bit PWMモジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD6  = 0;   // 16bit PWMモジュールストップ解除
    R_MSTP->MSTPCRD_b.MSTPD14 = 0;   // POEGモジュールストップ解除
//  GPT2(16bit) D4 P103 GTIOC2A 1Hz方形波出力
    R_PFS->PORT[1].PIN[3].PmnPFS_b.PDR  = 1;        // ポート出力
    R_PFS->PORT[1].PIN[3].PmnPFS_b.PSEL = 0b00011;  // GTIOC2A出力に
    R_PFS->PORT[1].PIN[3].PmnPFS_b.PMR  = 1;        // 周辺機能有効
    R_GPT2->GTCR_b.TPCS   = 0b1010;     // PCLKD/1024 46875Hz
    R_GPT2->GTPR          = 46875 - 1;  // 1Hz
    R_GPT2->GTCCR[0]      = 46875 / 2;  // GTIOC2AがHになるカウント
    R_GPT2->GTIOR_b.GTIOA = 0b00110;    // GTIOC2A 周期の終わりでL, A一致でH
    R_GPT2->GTIOR_b.OAE   = 1;          // A出力許可
    R_GPT2->GTCR_b.CST    = 1;          // カウント開始
//  GPT1(32bit) D3 P104 GTIOC1B インプットキャプチャAに
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PCR  = 1;        // P104入力pullup
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PSEL = 0b00010;  // GTETRGB入力に
    R_PFS->PORT[1].PIN[4].PmnPFS_b.PMR  = 1;        // 周辺機能有効
    R_GPT1->GTICASR_b.ASGTRGBF          = 1;        // B↓でキャプチャA
    R_GPT1->GTCSR_b.CSGTRGBF            = 1;        // B↓でクリア
//  GPT1(32bit) D2 P105 GTIOC1A クロック入力 upカウント
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PCR  = 1;        // P105入力pullup
//  R_PFS->PORT[1].PIN[5].PmnPFS_b.PSEL = 0b00010;  // GTETRGA入力に
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PSEL = 0b00011;  // ★GTIOC1A入力に
    R_PFS->PORT[1].PIN[5].PmnPFS_b.PMR  = 1;        // 周辺機能有効
//  R_GPT1->GTUPSR_b.USGTRGAF           = 1;        // A↓でカウントアップ
    R_GPT1->GTUPSR_b.USCAFBL            = 1;        // ★B=L,A↓でカウントアップ
    R_GPT1->GTUPSR_b.USCAFBH            = 1;        // ★B=H,A↓でカウントアップ
    R_GPT1->GTCR_b.CST                  = 1;        // カウント開始
//  D8:P304 GPT7 A出力を1MHz出力
    R_PFS->PORT[3].PIN[4].PmnPFS_b.PDR  = 1;        // ポート出力に
    R_PFS->PORT[3].PIN[4].PmnPFS_b.PSEL = 0b00011;  // GTIOC7A
    R_PFS->PORT[3].PIN[4].PmnPFS_b.PMR  = 1;        // 機能出力有効
    R_GPT7->GTPR          = 24 - 1;     // 48MHz/24=2MHz トグルで1/2して1MHz
    R_GPT7->GTIOR_b.GTIOA = 0b01100;    // GTIOC2A 周期の終わりでトグル出力
    R_GPT7->GTIOR_b.OAE   = 1;          // A出力許可
    R_GPT7->GTCR_b.CST    = 1;          // カウント開始
}
/*****  LOOP  *****/
void loop()
{
char str_bff[40];       // 文字出力バッファ sprintfで使用
    Serial.begin(9600);         // シリアル 9600BPSで
    while (!Serial);            // USB接続okチェック
    Serial.println("Frq counter");  // タイトル
//  loop
    while(1){
      if(R_GPT1->GTST_b.TCFA){      // キャプチャA発生?
        R_GPT1->GTST_b.TCFA = 0;    // キャプチャAクリア
        sprintf(str_bff, "%8ld.%03ldkHz", // 周波数表示
                R_GPT1->GTCCR[0] / 1000,  // キャプチャAデータ
                R_GPT1->GTCCR[0] % 1000);
        Serial.println(str_bff);
      }
    }
}
