/* ------ どこでもドアっぽいDOOR ------
* ArduinoUnoR4WiFi
* [Door動作プログラム4 OK]
* 測距センサー　Open/スローClose
* LED Matrix 文字/アニメーション表示　
* LED Matrix センサー値表示
* シリアルモニター115200:センサー値表示
* 2025/7/4 Saichi-Tanji
* ----------------------------------
*/
#include <Servo.h>
#include "ArduinoGraphics.h"
#include "Arduino_LED_Matrix.h"
ArduinoLEDMatrix matrix;
Servo door;
int doorPin = 9;
int open = 0;
int close = 90;
int senserPin = 0;
int kyori = 0;
int ledPin = 13;
const uint32_t ningen1[] = { //アニメーションデータ設定1
0x14,
0x538e5141,
0x42cb208,
66
};
const uint32_t ningen2[] = { //アニメーションデータ設定2
0x51,
0x438e1451,
0x428a492,
66
};
const uint32_t ningen3[] = { //アニメーションデータ設定3
0x10,
0x438e5551,
0x428a28a,
66
};
void setup() {
Serial.begin(115200);
matrix.begin();
pinMode(ledPin ,OUTPUT);
digitalWrite(ledPin, LOW);
door.attach(doorPin);
dispClose();
door.write(close);
delay(500);
}
void loop() {
kyoriSens();
if (kyori >=450 ) {
digitalWrite(ledPin, HIGH);
door.write(open);
dispOpen();
Serial.println(" ");
while(kyori > 350) {
kyoriSens();
ningen();
}
digitalWrite(ledPin, LOW);
delay(100);
dispClose();
for (int i = open; i <= close; i++) {
door.write(i);
delay(20);
}
}
}
void kyoriSens() {
kyori = 0 ;
for (int i = 0 ; i < 100; i++) {
kyori = kyori + analogRead(senserPin);
}
kyori = kyori / 100;
Serial.println(kyori);
dispMatrix( kyori );
}
void dispMatrix(int Suu) {
matrix.beginDraw();
const char zero1[] = "0";
const char zero2[] = "00";
String No = String( Suu );
matrix.textFont(Font_4x6);
matrix.beginText(1, 2, 0xFFFFFF);
if ( Suu <=9 ) {
matrix.println(zero2 + No); // 00 + 値1桁 表示
} else if (Suu <=99 ) {
matrix.println(zero1 + No); // 0 + 値2桁 表示
} else {
matrix.println(No); // 値3桁 表示
}
matrix.endText();
matrix.endDraw();
}
void ningen() {
matrix.loadFrame(ningen1);
delay(100);
matrix.loadFrame(ningen2);
delay(200);
matrix.loadFrame(ningen3);
delay(100);
}
void dispOpen() {
matrix.beginDraw();
matrix.stroke(0xFFFFFFFF);
matrix.textScrollSpeed(40);
// add the text
const char text[] = " << Open! ";
matrix.textFont(Font_5x7);
matrix.beginText(0, 1, 0xFFFFFF);
matrix.println(text);
matrix.endText(SCROLL_LEFT);
matrix.endDraw();
}
void dispClose() {
matrix.beginDraw();
matrix.stroke(0xFFFFFFFF);
matrix.textScrollSpeed(40);
// add the text
const char text[] = " >> Close! ";
matrix.textFont(Font_5x7);
matrix.beginText(0, 1, 0xFFFFFF);
matrix.println(text);
matrix.endText(SCROLL_LEFT);
matrix.endDraw();
}