import os

# UART設定
baud_rate = 57600
bit_time = 1 / baud_rate  # ≈ 13.3611 us
slope_time = 50e-9  # 50ns

# UARTデータ
data_bytes = [0x11,0x11,0x11,0x11,0x11]

# 出力用PWLリスト
pwl = []

# 初期状態：アイドルHigh
t = 0.0
current_level = 3.3
pwl.append((t, current_level))

def add_level(pwl, t_start, t_end, level):
    if t_start == t_end:
        return
    pwl.append((t_start, level))
    pwl.append((t_end, level))

# 電圧変化の処理
def add_transition(pwl, t, from_level, to_level):
    if from_level == to_level:
        return t
    pwl.append((t, from_level))
    pwl.append((t + slope_time, to_level))
    return t + slope_time

# シリアルデータ生成
for byte in data_bytes:
    bits = [0]  # Start bit
    bits += [(byte >> i) & 0x1 for i in range(8)]  # Data bits LSB→MSB
    bits += [1]  # Stop bit

    for bit in bits:
        level = 3.3 if bit else 0.0
        if level != current_level:
            t = add_transition(pwl, t, current_level, level)
            t_level_start = t
            current_level = level
        else:
            t_level_start = t
        t += bit_time - slope_time
        add_level(pwl, t_level_start, t, level)

# 最後：2msまでHigh維持
if current_level != 3.3:
    t = add_transition(pwl, t, current_level, 3.3)
    current_level = 3.3
t_final = 0.002
add_level(pwl, t, t_final, 3.3)

# 時間・レベルでソート（念のため）
pwl.sort()

# 重複ポイントの削除（同じ時間に同じレベルが複数ある場合）
cleaned = []
for i, (time, level) in enumerate(pwl):
    if i == 0 or (time != pwl[i - 1][0] or level != pwl[i - 1][1]):
        cleaned.append((time, level))

# 出力
with open("uart_pwlsig.txt", "w") as f:
    for time, level in cleaned:
        f.write(f"{time:.9f} {level:.3f}\n")

print("PWL信号ファイル 'uart_pwlsig.txt' を生成しました。")
