const int pwm_pin = 3;
const int analog_pin_freq = A0;
const int analog_pin_duty = A1;

void setup() {
  pinMode(pwm_pin, OUTPUT);
  Serial.begin(115200);
}

void loop() {
  int freq_val = analogRead(analog_pin_freq);
  int duty_val = analogRead(analog_pin_duty);

  int freq = map(freq_val, 0, 1023, 100, 10000);   // 100Hz～10kHz
  int duty = map(duty_val, 0, 1023, 0, 255);       // 0～255(8bit PWM)

  analogWriteFrequency(pwm_pin, freq);  // 周波数セット
  analogWrite(pwm_pin, duty);            // デューティセット

  Serial.print("freq: ");
  Serial.print(freq);
  Serial.print(" Hz, duty: ");
  Serial.println(duty);

  delay(50);
}

