# protocol.py — 共通プロトコル定義（LENは32bit, CRC16-CCITT）
PREFIX      = b"\x55\xAB"  # 2B
MASTER_ADDR = 0x00

# 制御
CMD_ASSIGN  = 0x10  # unicast: <seq:1><imgW:2><imgH:2><x0:2><y0:2><w:2><h:2>
CMD_ACK     = 0x11  # unicast: <seq:1>

# タイル転送（worker→master）
CMD_TILE    = 0x21  # <x0:2><y0:2><w:2><h:2> + 2*w*h + CRC16(末尾に別送)

# トークン（順次送信のバトン）
CMD_TOKEN   = 0x30  # unicast: <id0,id1,...> 先頭が受信者自身→タイル送信→残りの先頭へリレー

def c2s(cmd):
    d = {CMD_ASSIGN: "CMD_ASSIGN",
         CMD_ACK: "CMD_ACK",
         CMD_TILE: "CMD_TILE",
         CMD_TOKEN: "CMD_TOKEN"}
    return d[cmd]
